<?php $__env->startSection('title', 'About Us - ENT Care Center'); ?>
<?php $__env->startSection('meta_description', 'Learn about ENT Care Center, our mission, vision, and our team of expert ENT specialists.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<!-- Page Header -->
<section class="relative h-[40vh] min-h-[400px] flex items-center justify-center overflow-hidden bg-primary-900">
    <div class="absolute inset-0 bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 opacity-90"></div>
    <div class="absolute inset-0 bg-[url('/img/pattern.png')] opacity-10"></div>
    
    <!-- Animated shapes -->
    <div class="absolute top-20 left-10 w-64 h-64 bg-primary-500/20 rounded-full blur-3xl animate-pulse-slow"></div>
    <div class="absolute bottom-10 right-10 w-80 h-80 bg-accent-500/20 rounded-full blur-3xl animate-pulse-slow" style="animation-delay: 1s;"></div>
    
    <div class="relative z-10 text-center text-white px-4 max-w-4xl mx-auto">
        <span class="inline-block px-4 py-1.5 mb-6 text-sm font-semibold tracking-wider text-primary-200 uppercase bg-primary-800/50 rounded-full border border-primary-700/50 backdrop-blur-sm">
            Our Story
        </span>
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-bold mb-6 tracking-tight">About Us</h1>
        <p class="text-lg sm:text-xl text-primary-100 max-w-2xl mx-auto font-light leading-relaxed">Dedicated to providing exceptional ear, nose, and throat care with a patient-centered approach.</p>
    </div>
</section>

<!-- About Content -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-8 text-center tracking-tight">Welcome to ENT Care Center</h2>
            <div class="prose prose-lg prose-slate max-w-none text-secondary-600">
                <p class="leading-relaxed mb-6">
                    ENT Care Center is a leading medical facility specializing in ear, nose, and throat conditions. We are committed to providing comprehensive, compassionate, and high-quality healthcare services to our patients.
                </p>
                <p class="leading-relaxed mb-6">
                    With a team of experienced and board-certified ENT specialists, we offer a wide range of diagnostic and treatment services using the latest medical technology and evidence-based practices. Our clinic has been serving the community for over two decades, building a reputation for excellence in ENT care.
                </p>
                <p class="leading-relaxed mb-6">
                    Our patient-centered approach ensures that each individual receives personalized care tailored to their specific needs. We believe in building long-term relationships with our patients based on trust, respect, and excellent medical outcomes.
                </p>
                <div class="bg-primary-50 border-l-4 border-primary-500 p-6 my-8 rounded-r-xl">
                    <p class="text-primary-800 font-medium italic m-0">
                        "We understand that visiting a medical facility can be stressful, which is why we've created a warm, welcoming environment where patients feel comfortable and cared for."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<!-- Mission & Vision -->
<section class="py-20 bg-secondary-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 lg:gap-12">
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-soft transition-all duration-300 border border-secondary-100 group">
                <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-6 text-primary-600 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-secondary-900 mb-4">Our Mission</h3>
                <p class="text-secondary-600 leading-relaxed">
                    To provide exceptional ear, nose, and throat medical care that improves the health and quality of life of our patients. We are dedicated to excellence in diagnosis, treatment, and patient education.
                </p>
            </div>
            
            <div class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-soft transition-all duration-300 border border-secondary-100 group">
                <div class="w-14 h-14 bg-accent-100 rounded-xl flex items-center justify-center mb-6 text-accent-600 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-secondary-900 mb-4">Our Vision</h3>
                <p class="text-secondary-600 leading-relaxed">
                    To be the premier ENT care center recognized for clinical excellence, innovative treatments, and outstanding patient satisfaction. We strive to set the standard for ENT healthcare delivery.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Our Values -->
<!-- Our Values -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-4 tracking-tight">Our Core Values</h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto font-light">The principles that guide everything we do</p>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center p-6 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-lg transition-all duration-300 border border-transparent hover:border-secondary-100 group">
                <div class="w-14 h-14 bg-blue-100 text-blue-600 rounded-xl flex items-center justify-center mx-auto mb-6 group-hover:bg-blue-600 group-hover:text-white transition-all duration-300">
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-secondary-900 mb-3">Compassion</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">Treating every patient with empathy and genuine care.</p>
            </div>
            <!-- Repeat for other values with different colors -->
            <div class="text-center p-6 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-lg transition-all duration-300 border border-transparent hover:border-secondary-100 group">
                <div class="w-14 h-14 bg-purple-100 text-purple-600 rounded-xl flex items-center justify-center mx-auto mb-6 group-hover:bg-purple-600 group-hover:text-white transition-all duration-300">
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-secondary-900 mb-3">Excellence</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">Maintaining the highest standards of medical practice.</p>
            </div>
            <div class="text-center p-6 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-lg transition-all duration-300 border border-transparent hover:border-secondary-100 group">
                <div class="w-14 h-14 bg-green-100 text-green-600 rounded-xl flex items-center justify-center mx-auto mb-6 group-hover:bg-green-600 group-hover:text-white transition-all duration-300">
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-secondary-900 mb-3">Integrity</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">Acting with honesty and transparency in all interactions.</p>
            </div>
            <div class="text-center p-6 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-lg transition-all duration-300 border border-transparent hover:border-secondary-100 group">
                <div class="w-14 h-14 bg-orange-100 text-orange-600 rounded-xl flex items-center justify-center mx-auto mb-6 group-hover:bg-orange-600 group-hover:text-white transition-all duration-300">
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-bold text-secondary-900 mb-3">Innovation</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">Embracing new technologies to improve patient outcomes.</p>
            </div>
        </div>
    </div>
</section>

<!-- Doctors -->
<!-- Doctors -->
<section class="py-20 bg-secondary-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-4 tracking-tight">Our Expert Team</h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto font-light">Meet our experienced specialists dedicated to providing you with the best ENT care</p>
        </div>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-2xl overflow-hidden shadow-sm hover:shadow-xl transform hover:-translate-y-2 transition-all duration-300 group border border-secondary-100">
                <div class="relative h-64 overflow-hidden">
                    <?php if($doctor->image): ?>
                        <img src="<?php echo e(asset('storage/' . $doctor->image)); ?>" 
                             alt="<?php echo e($doctor->name); ?>" 
                             class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500">
                    <?php else: ?>
                        <div class="w-full h-full bg-secondary-100 flex items-center justify-center">
                            <svg class="w-24 h-24 text-secondary-300" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                    <?php endif; ?>
                    <div class="absolute inset-0 bg-gradient-to-t from-secondary-900/80 via-transparent to-transparent opacity-60 group-hover:opacity-80 transition-opacity"></div>
                    <div class="absolute bottom-0 left-0 right-0 p-6">
                        <h3 class="text-xl font-bold text-white mb-1"><?php echo e($doctor->name); ?></h3>
                        <p class="text-primary-300 font-medium text-sm bg-primary-900/40 inline-block px-2 py-0.5 rounded backdrop-blur-sm"><?php echo e($doctor->specialization); ?></p>
                    </div>
                </div>
                <div class="p-6">
                    <p class="text-sm font-semibold text-secondary-400 mb-3 uppercase tracking-wide"><?php echo e($doctor->credentials); ?></p>
                    <?php if($doctor->bio): ?>
                    <p class="text-secondary-600 mb-4 line-clamp-3 leading-relaxed text-sm"><?php echo e($doctor->bio); ?></p>
                    <?php endif; ?>
                    <?php if($doctor->experience_years > 0): ?>
                    <div class="flex items-center text-secondary-500 text-sm border-t border-secondary-100 pt-4 mt-auto">
                        <svg class="w-5 h-5 mr-2 text-primary-500" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <span class="font-medium"><?php echo e($doctor->experience_years); ?> years of experience</span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-12">
                <p class="text-secondary-500 text-lg">Our doctor profiles will be available soon.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-primary-600 relative overflow-hidden">
    <!-- Decorative patterns -->
    <div class="absolute top-0 left-0 -ml-20 -mt-20 w-80 h-80 rounded-full bg-primary-500 opacity-20 blur-3xl"></div>
    <div class="absolute bottom-0 right-0 -mr-20 -mb-20 w-80 h-80 rounded-full bg-accent-500 opacity-20 blur-3xl"></div>
    
    <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center text-white">
        <h2 class="text-3xl md:text-5xl font-bold mb-6 tracking-tight">Schedule Your Consultation</h2>
        <p class="text-lg md:text-xl mb-10 text-primary-100 font-light max-w-2xl mx-auto">Experience the difference of expert ENT care with our dedicated team of specialists.</p>
        <a href="<?php echo e(route('appointment.create')); ?>" 
           class="inline-flex items-center space-x-2 px-8 py-4 bg-white text-primary-600 rounded-xl font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-300">
            <span>Book Appointment</span>
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
            </svg>
        </a>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/about.blade.php ENDPATH**/ ?>